% fobj = @YourCostFunction
% dim = number of your variables
% Max_iteration = maximum number of generations
% SearchAgents_no = number of search agents
% lb=[lb1,lb2,...,lbn] where lbn is the lower bound of variable n
% ub=[ub1,ub2,...,ubn] where ubn is the upper bound of variable n
% If all the variables have equal lower bound you can just
% define lb and ub as two single number numbers

% To run WOA: [Best_score,Best_pos,WOA_cg_curve]=WOA(SearchAgents_no,Max_iteration,lb,ub,dim,fobj)
%__________________________________________

clear all 
clc

SearchAgents_no=30; % Number of search agents

Function_name='F1'; % Name of the test function that can be from F1 to F15 (Table 3,4,5 in the paper)
F_index=1;
Max_iteration=500; % Maximum numbef of iterations
ElitistCheck=1; Rpower=1;
min_flag=1;
% Load details of the selected benchmark function
[lb,ub,dim,fobj]=Get_Functions_details(Function_name);
for func_num=1:4
for jjj=1:30
if func_num==1
func_num
jjj

[Best_score,Best_pos,WOA_cg_curve]=IWOA(SearchAgents_no,Max_iteration,lb,ub,dim,fobj);
Best_res(func_num,jjj)=Best_score;

elseif func_num==2
func_num
jjj

[Best_score1,Best_pos1,WOA_cg_curve1]=WOA(SearchAgents_no,Max_iteration,lb,ub,dim,fobj);
Best_res(func_num,jjj)=Best_score1;



elseif func_num==3
func_num
jjj
[Fbest,Lbest,BestChart,MeanChart]=GSA(F_index,SearchAgents_no,Max_iteration,ElitistCheck,min_flag,Rpower,lb,ub,dim);
Best_res(func_num,jjj)=Fbest;
elseif func_num==4
func_num
jjj
[cg_curve,gBestScore]=PSO(SearchAgents_no,Max_iteration,lb,ub,dim,fobj);
Best_res(func_num,jjj)=gBestScore;
end
end
end
for func_num=1:4
disp('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~')
func_num;
if func_num==1
fprintf('result of improved-WOA\n'),fprintf('Average=%d\n',mean(Best_res(func_num,:)')),fprintf('Standard-deviation=%d\n',std(Best_res(func_num,:)'))
end
if func_num==2
fprintf('result of WOA\n'),fprintf('Average=%d\n',mean(Best_res(func_num,:)')),fprintf('Standard-deviation=%d\n',std(Best_res(func_num,:)'))
end
if func_num==3
fprintf('result of PSO\n'),fprintf('Average=%d\n',mean(Best_res(func_num,:)')),fprintf('Standard-deviation=%d\n',std(Best_res(func_num,:)'))
end
if func_num==4
fprintf('result of GSA\n'),fprintf('Average=%d\n',mean(Best_res(func_num,:)')),fprintf('Standard-deviation=%d\n',std(Best_res(func_num,:)'))
end
end

semilogy(WOA_cg_curve,'Color','black')
hold on
semilogy(WOA_cg_curve1,'Color','b')
hold on

semilogy(cg_curve,'Color','r')

hold on
semilogy(MeanChart,'Color','c')

title('Objective space')
xlabel('Iteration');
ylabel('Best Average score obtained ');

axis tight
grid on
box on
legend('I-WOA','WOA','GSA','PSO')


        



