% GSA code v1.1.
% Generated by Esmat Rashedi, 2010. 
% "	E. Rashedi, H. Nezamabadi-pour and S. Saryazdi,
%GSA: A Gravitational Search Algorithm, Information sciences, vol. 179,
%no. 13, pp. 2232-2248, 2009."
%
% This function calculates the value of the objective function.
function fit=test_functions(L,F_index,dim)

%Insert your own objective function with a new F_index.

if F_index==1
fit=sum(L.^2);
end

if F_index==2
    fit=sum(100*(L(2:dim)-(L(1:dim-1).^2)).^2+(L(1:dim-1)-1).^2);
end

if F_index==3
    fit=sum(floor((L+.5)).^2);
end

if F_index==4
    fit=0;
    for i=1:dim
    fit=fit+sum(L(1:i))^2;
    end
end

if F_index==5
    fit=sum([1:dim].*(L.^4))+rand;
end

if F_index==6
    fit=max(abs(L));
end

if F_index==7
    fit=sum(L.^2-10*cos(2*pi.*L))+10*dim;
end

if F_index==8
    fit=-20*exp(-.2*sqrt(sum(L.^2)/dim))-exp(sum(cos(2*pi.*L))/dim)+20+exp(1);
end

if F_index==9
    fit=sum(-L.*sin(sqrt(abs(L))));
end

if F_index==10
    fit=sum(L.^2)/4000-prod(cos(L./sqrt([1:dim])))+1;
end

if F_index==11
    fit=(pi/dim)*(10*((sin(pi*(1+(L(1)+1)/4)))^2)+sum((((L(1:dim-1)+1)./4).^2).*...
        (1+10.*((sin(pi.*(1+(L(2:dim)+1)./4)))).^2))+((L(dim)+1)/4)^2)+sum(Ufun(L,10,100,4));
end

if F_index==12
    aK=[.1957 .1947 .1735 .16 .0844 .0627 .0456 .0342 .0323 .0235 .0246];
    bK=[.25 .5 1 2 4 6 8 10 12 14 16];bK=1./bK;
    fit=sum((aK-((L(1).*(bK.^2+L(2).*bK))./(bK.^2+L(3).*bK+L(4)))).^2);
end

if F_index==13
    fit=0;
  for i=1:7
    fit=fit-((L-aSH(i,:))*(L-aSH(i,:))'+cSH(i))^(-1);
  end
end

if F_index==14
    fit=0;
  for i=1:5
    fit=fit-((L-aSH(i,:))*(L-aSH(i,:))'+cSH(i))^(-1);
  end
end

if F_index==15
    aH=[3 10 30;.1 10 35;3 10 30;.1 10 35];cH=[1 1.2 3 3.2];
    pH=[.3689 .117 .2673;.4699 .4387 .747;.1091 .8732 .5547;.03815 .5743 .8828];
    fit=0;
    for i=1:4
    fit=fit-cH(i)*exp(-(sum(aH(i,:).*((L-pH(i,:)).^2))));
    end
end



function y=Ufun(x,a,k,m)
y=k.*((x-a).^m).*(x>a)+k.*((-x-a).^m).*(x<(-a));
return